
// BITimeEntry.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.

/*!
    @class       BITimeEntry
    @abstract    BITimeEntry represents a duration of time where the user performed work on a particular slip.
    @discussion  There are two types of time entries.  Manual and not-manual.  A manual time entry is a time entry which was explicitly created by the user and where the user specified the duration of time for the entry.  A not-manual entry is one which was created and the duration was specified by the timer.
*/


#ifdef BILLINGS_PRO
#import "_BPTimeEntry.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BITimeEntry.h"
#endif
#import "BIAppVersioning.h"


@interface BITimeEntry : BL_SUPER_CLASSNAME_MUNGE(TimeEntry) 
{
	BOOL isActive;
}

- (void)setInitialValues;
- (void)setInitialValuesWithObjectContext:(id)oc;

- (int)calculateDurationInMinutes;
- (void)setCalculateDurationInMinutes:(id)aMinutes;

- (long)calculateDurationInSeconds;
- (void)setCalculatedDurationInSeconds:(id)aSeconds;

- (NSNumber*)durationInSecondsWrapper;
- (void)setDurationInSecondsWrapper:(NSNumber*)aDuration;

- (BOOL)isManualBool;
- (void)setIsManualBool:(BOOL)aFlag;

//- (id)isActive;
//- (void)setIsActive:(id)aFlag;
- (BOOL)isActive;
- (void)setIsActive:(BOOL)aFlag;

/* These methods are wrappers to set the start date time 
   they will change the start date time and the end time effectively 
   based on the duration.. so that the duration is kept when the 
   start date is changed */
- (void)setStartDateTimeWrapper:(NSCalendarDate *)aValue;
- (NSCalendarDate *)startDateTimeWrapper;

- (void)setEndDateTimeWrapper:(NSCalendarDate *)aValue;
- (NSCalendarDate *)endDateTimeWrapper;


- (NSArray*)plistKeys;
- (NSDictionary*)plistRepresentation;
- (void)restoreValuesFromPlist:(NSDictionary*)aDict;

// we should not use this because some people start/stop the timer very frequently
- (void)roundDownToMinute;

@end
